package furny.ga.test;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.logging.Logger;

import furny.entities.Furniture;
import furny.furndb.FurnCache;
import furny.ga.util.FurnitureUtil;

public final class TestSimilarity {

  // the logger for this class
  private static final Logger LOGGER = Logger.getLogger(TestSimilarity.class
      .getName());

  private static NumberFormat format = new DecimalFormat("0.00");

  private TestSimilarity() {
  }

  public static void main(final String[] args) {
    final List<Furniture> list = FurnCache.getInstance().getAllFurnitures();

    for (final Furniture f1 : list) {
      for (final Furniture f2 : list) {
        checkSimilarity(f1, f2, 10f, 10f);
      }
    }

    // final PriorityQueue<Furniture> queue = new PriorityQueue<Furniture>(
    // list.size(), new FurnitureTagComparator());
    // queue.addAll(list);
    //
    // LOGGER.info(queue.toString());

    final Furniture furn = list.get(0);
    // final Map<Furniture, Float> map = FurnitureUtil
    // .getSimilarityMap(furn, list);
    //
    // LOGGER.info("\n Similarity percent for " + furn);
    //
    // for (final Furniture f : map.keySet()) {
    // LOGGER.info(format.format(map.get(f)) + "  " + f);
    // }

    // final Map<Furniture, Integer> map2 = FurnitureUtil.getSimilarityRankMap(
    // furn, list);
    //
    // LOGGER.info("Similarity ranking for " + furn);
    //
    // for (final Furniture f : map2.keySet()) {
    // LOGGER.info(map2.get(f) + "  " + f);
    // }

    // final Map<Furniture, Integer> map2 = FurnitureUtil.getSimilarityRankMap(
    // furn, list);
    //
    // LOGGER.info("\n Similarity ranking for " + furn);
    //
    // for (final Furniture f : map2.keySet()) {
    // LOGGER.info(map2.get(f) + "  " + f);
    // }

    // LOGGER.info("\n Similarity probability for " + furn);
    // LOGGER.info(FurnitureUtil.getSimilarityProbabilityList(furn, list)
    // .toString());

    // final Map<Furniture, Float> map3 = FurnitureUtil.getSimilarityMap2(furn,
    // list);
    //
    // LOGGER.info("Similarity percent2 for " + furn);
    //
    // for (final Entry<Furniture, Float> entry : map3.entrySet()) {
    // LOGGER.info(format.format(entry.getValue()) + "  " + entry.getKey());
    // }

    // final Map<Furniture, Integer> map4 = FurnitureUtil.getSimilarityRankMap2(
    // furn, list);
    //
    // LOGGER.info("Similarity ranking2 for " + furn);
    //
    // for (final Entry<Furniture, Integer> entry : map4.entrySet()) {
    // LOGGER.info(entry.getValue() + "  " + entry.getKey());
    // }
  }

  private static void checkSimilarity(final Furniture f1, final Furniture f2,
      final float width, final float length) {
    final double f = FurnitureUtil.getSimilarity(f1, f2);

    LOGGER.info(format.format(f) + "  " + f1 + " / " + f2);
  }
}
